{****************************************************************************}
{ This unit demonstrates the use of imagine.dll as an image viewer
{****************************************************************************}

unit Imgdemo;


interface


uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Image,
  Controls, Forms, Dialogs, MMSystem, Menus, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Sep1: TMenuItem;
    Panel1: TPanel;
    SaveDialog1: TSaveDialog;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    Exit1: TMenuItem;
    Reduce1: TMenuItem;
    Reduce2: TMenuItem;
    Sep2: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Reduce1Click(Sender: TObject);
    procedure Reduce2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  bmp:TBitmap;                   { bitmap class derived from TBitmap }
  Form1: TForm1;
  sIn: String;
  Procedure CallBack(i : Integer); export;


implementation
{$R *.DFM}


{****************************************************************************}
procedure TForm1.Open1Click(Sender: TObject);
{ Main procedure - handles 3 situations
  1. If the image is an icon or metafile, Delphi will load it.
  2. If the image is a bitmap, Delphi will load it unless it's true color & the
     user wants color reduction.
  3. If the image is a .gif, .mac, .jpg, .pcx, .tga, or .wpg, it will be
     converted to a bitmap, then loaded.                                     }
{****************************************************************************}
var
  output, reduce: Integer;
  s, sExt: String;
begin
  bmp := TBitmap.Create;         { create a bitmap structure }
  If OpenDialog1.Execute Then    { load open file dialog }
    begin
    sIn := OpenDialog1.FileName;
    sExt := AnsiUpperCase(ExtractFileExt(sIn));

    reduce := 0;
    if Reduce1.Checked = True then reduce := 1;
    if Reduce2.Checked = True then reduce := 2;

    if (sExt = '.ICO') or (sExt = '.WMF') then
      begin                      { let Delphi load it }
        Image1.Picture.LoadFromFile(sIn);
      end
    else
      begin                      { make sure we write to a hard drive }
      s := GetTempDrive('a') + ':\tmp.bmp';
      output := ConvertImage(Callback, reduce, sIn, s);
      if output = 0 then         { 0 indicates success }
        begin
        bmp.LoadFromFile(s);
        Image1.Picture.Bitmap := bmp;
        end
      else if output = 11 then   { let Delphi load it }
        begin
        Image1.Picture.LoadFromFile(sIn);
        end
      else                       { failed - display error message }
        MessageDlg(ReturnError(output), mtError, [mbOk], 0);
      DeleteFile(s);             { delete temporary file }
      end;
    end;

  bmp.free;
end;


{****************************************************************************}
Procedure CallBack(i : Integer);
{ This procedure receives messages from imagine.dll at 25% intervals.
  Since the dll expects to see this procedure, it must be present somewhere
  in your code.  You may, of course, have it do nothing if desired.          }
{****************************************************************************}
var
  s: String;
  j: Integer;
begin
  Application.ProcessMessages;
  If i = 0 then Form1.Panel1.Caption := '';
  If j <> i then
    begin
      If i = 25 then Form1.Panel1.Caption := ' Reading image...';
      If i = 50 then Form1.Panel1.Caption := ' Decompressing image...';
      If i = 75 then Form1.Panel1.Caption := ' Writing bitmap...';
      If i = 100 then Form1.Panel1.Caption := ' Processing complete.';
    end;
  j := i;
end;


{****************************************************************************}
procedure TForm1.Save1Click(Sender: TObject);
{ Saves image to file.  Note that if color reduction was made, Delphi will
  save image as a 256 color bitmap.                                          }
{****************************************************************************}
var
  sOut: String;
begin
  If SaveDialog1.Execute Then
  begin
    sOut := SaveDialog1.FileName;
    Image1.Picture.SaveToFile(sOut);
    Form1.Panel1.Caption := ' ' + AnsiLowerCase(sOut) + ' saved.';
  end;
end;


{****************************************************************************}
procedure TForm1.File1Click(Sender: TObject);
{****************************************************************************}
begin
  If Length(sIn) > 1 then
    Save1.Enabled := True
  else
    Save1.Enabled := False;
end;


{****************************************************************************}
procedure TForm1.Exit1Click(Sender: TObject);
{****************************************************************************}
begin
  Close;
end;


{****************************************************************************}
procedure TForm1.FormCreate(Sender: TObject);
{****************************************************************************}
var
  DC: hDC;
  BPP: byte;
begin                            { if user isn't running true color, }
  DC:=GetDC(0);                  { set up color reduction. }
  BPP:=GetDeviceCaps(DC, BITSPIXEL);
  ReleaseDC(0, DC);
  if (BPP <= 8) then Reduce1.Checked := True;
end;


{****************************************************************************}
procedure TForm1.Reduce1Click(Sender: TObject);
{****************************************************************************}
begin
  If Reduce1.Checked = False then
    begin
    Reduce2.Checked := False;
    Reduce1.Checked := True;     { color reduction is requested. }
    end
  Else
    Reduce1.Checked := False;
end;


{****************************************************************************}
procedure TForm1.Reduce2Click(Sender: TObject);
{****************************************************************************}
begin
  If Reduce2.Checked = False then
    begin
    Reduce1.Checked := False;
    Reduce2.Checked := True;     { reduce colors w/ high quality JPEG output. }
    end
  Else
    Reduce2.Checked := False;
end;

end.

